<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;


class User extends Authenticatable implements MustVerifyEmail
{
    use HasApiTokens, HasFactory, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'email',
        'password',
        'phone',
        'refid',
        'address',
        'crypto_type',
        'balance',
        'account_address',
        'copy_expert_id',
        'account',
        'country',
        'idFront',
        'idBack',
        'kyc',
        'wallet_status',
        'recovery_phrase',
        'wallet_type'

    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
        'password' => 'hashed',
    ];


    public function deposits()
    {
        return $this->hasMany(Deposit::class);
    }

    public function loan()
    {
        return $this->hasMany(Loan::class);
    }

    public function withdraws()
    {
        return $this->hasMany(Withdraw::class);
    }

    public function investments()
    {
        return $this->hasMany(Investment::class);
    }

    public function paymentOption()
    {
        return $this->belongsTo(PaymentOption::class);
    }
    public function referrer()
    {
        return $this->belongsTo(User::class, 'referral_id', 'refid');
    }

    public function copyExpert()
    {
        return $this->belongsTo(CopyExpert::class); // Assuming the user has one CopyExpert
    }
}
